package applicazione;

import java.util.GregorianCalendar;

import attivitaprincipale.Rinnovo;

import utente.*;
import contratto.*;
import contrattofedelta.*;
import trasmissione.*;
import trasmissionedati.*;
import trasmissionevoce.*;
import possedere.*;
import possederefedelta.*;

public class Main {

	public static void main(String[] args) {

		Trasmissione t1 = new TrasmissioneDati(110, 3);
		Trasmissione t2 = new TrasmissioneVoce(150, "canale 1");
		Trasmissione t3 = new TrasmissioneVoce(200, "canale 2");

		Utente u1 = new Utente("Massimo", "Mecella", "MCLMSM");
		u1.inserisciLinkEffettuare(t1);
		u1.inserisciLinkEffettuare(t2);
		u1.inserisciLinkEffettuare(t3);

		Contratto c1 = new Contratto("C123S");
		c1.setCosto(125);
		c1.setDataScadenza(new GregorianCalendar());

		Contratto c2 = new Contratto("C456S");
		c2.setCosto(180);
		c2.setDataScadenza(new GregorianCalendar());

		u1.inserisciLinkPossedere(new TipoLinkPossedere(u1, c1));
		u1.inserisciLinkPossedere(new TipoLinkPossedere(u1, c2));

		ContrattoFedelta c3 = new ContrattoFedelta("C789F");
		c3.setCosto(100);
		c3.setDataScadenza(new GregorianCalendar());
		c3.setInterventi(10);

		u1.inserisciLinkPossedere(new TipoLinkPossedere(u1, c3));
		u1.inserisciLinkPossedereFedelta(new TipoLinkPossedereFedelta(u1, c3));

		Rinnovo r = new Rinnovo(c3);
		new Thread(r).start();
	}

}
