package attivitaatomiche;

import java.util.*;
import _framework.*;
import contrattofedelta.*;
import trasmissione.*;

public class CalcoloInterventi implements Task {

	private boolean eseguita = false;
	private ContrattoFedelta contratto;
	private int result;

	public CalcoloInterventi(ContrattoFedelta c) {
		this.contratto = c;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita)
			return;
		eseguita = true;

		result = 0;

		int numeroTrasmissioni = contratto.getLinkPossedere().getUtente()
				.getLinkEffettuare().size();
		int sommaDurate = 0;

		Iterator<Trasmissione> it = contratto.getLinkPossedere().getUtente()
				.getLinkEffettuare().iterator();
		while (it.hasNext())
			sommaDurate += it.next().getDurata();

		if (numeroTrasmissioni != 0) {
			result = sommaDurate / numeroTrasmissioni;
			result = result / 10;
		}

	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

	public synchronized int getResult() {
		if (!eseguita) 	throw new RuntimeException(
		"ERRORE: non e' disponibile il risultato su un'attivita' non eseguita");
			return result;
	}

}