package attivitaatomiche;

import java.util.*;
import _framework.*;
import contratto.*;
import trasmissione.*;

public class CalcoloProposta implements Task {

	private boolean eseguita = false;
	private Contratto contratto;
	private int durataPeriodo;
	private int result;

	public CalcoloProposta(Contratto c, int durata) {
		this.contratto = c;
		this.durataPeriodo = durata;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita)
			return;
		eseguita = true;

		result = 0;

		int numeroTrasmissioni = contratto.getLinkPossedere().getUtente()
				.getLinkEffettuare().size();
		int sommaDurate = 0;

		Iterator<Trasmissione> it = contratto.getLinkPossedere().getUtente()
				.getLinkEffettuare().iterator();
		while (it.hasNext())
			sommaDurate += it.next().getDurata();

		if (numeroTrasmissioni != 0) {
			result = sommaDurate / numeroTrasmissioni;
			result = result * 1000;
			result = result / durataPeriodo;
		}

	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

	public synchronized int getResult() {
		if (!eseguita) 	throw new RuntimeException(
		"ERRORE: non e' disponibile il risultato su un'attivita' non eseguita");
			return result;
	}

}