package attivitaatomiche;

import _framework.*;
import contratto.*;

public class LeggiPrezzo implements Task {

	private boolean eseguita = false;
	private Contratto contratto;
	private int result;

	public LeggiPrezzo(Contratto c) {
		this.contratto = c;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita)
			return;
		eseguita = true;

		result = contratto.getCosto();
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

	public synchronized int getResult() {
		if (!eseguita) 	throw new RuntimeException(
		"ERRORE: non e' disponibile il risultato su un'attivita' non eseguita");
			return result;
	}

}