package attivitaatomiche;

import java.util.*;
import _framework.*;
import contrattofedelta.*;

public class RegistrazioneFedelta implements Task {

	private boolean eseguita = false;
	private ContrattoFedelta contratto;
	private int DURATAFEDELTA = 730;

	private int nuovoPrezzo;
	private int nuoviInterventi;
	private GregorianCalendar nuovaData;

	public RegistrazioneFedelta(ContrattoFedelta c, int p, int i) {
		this.contratto = c;
		this.nuovoPrezzo = p;
		this.nuoviInterventi = i;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita)
			return;
		eseguita = true;

		contratto.setInterventi(nuoviInterventi);
		contratto.setCosto(nuovoPrezzo);

		nuovaData = contratto.getDataScadenza();
		nuovaData.add(Calendar.DATE, DURATAFEDELTA);
		contratto.setDataScadenza(nuovaData);
	}

	public GregorianCalendar getDataScadenza() {
		if (!eseguita)
			throw new RuntimeException(
					"ERRORE: non e' disponibile il risultato su un'attivita' non eseguita");
		return nuovaData;
	}
	
	public synchronized boolean estEseguita() {
		return eseguita;
	}

}