package attivitaatomiche;

import java.util.*;
import _framework.*;
import contratto.*;

public class RegistrazioneStandard implements Task {

	private boolean eseguita = false;
	private Contratto contratto;
	private int nuovaDurata;
	private int nuovoPrezzo;
	private GregorianCalendar nuovaData;

	public RegistrazioneStandard(Contratto c, int d, int p) {
		this.contratto = c;
		this.nuovaDurata = d;
		this.nuovoPrezzo = p;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;

		contratto.setCosto(nuovoPrezzo);

		nuovaData = contratto.getDataScadenza();
		nuovaData.add(Calendar.DATE, nuovaDurata);
		contratto.setDataScadenza(nuovaData);

	}

	public GregorianCalendar getDataScadenza() {
		if (!eseguita)
			throw new RuntimeException(
					"ERRORE: non e' disponibile il risultato su un'attivita' non eseguita");
		return nuovaData;
	}
	
	public synchronized boolean estEseguita() {
		return eseguita;
	}

}