package attivitaprincipale;

import contratto.*;
import contrattofedelta.ContrattoFedelta;
import attivitaatomiche.*;
import attivitaio.*;
import _framework.*;

public class Rinnovo implements Runnable {
	private boolean eseguita = false;

	private Contratto c;

	public Rinnovo(Contratto c) {
		this.c = c;
	}

	public synchronized void run() {

		if (eseguita == true)
			return;
		eseguita = true;

		int nuovoPrezzo;
		int nuovaDurata;
		int nuoviInterventi;

		if (c.getClass() == ContrattoFedelta.class) {
			ContrattoFedelta cf = (ContrattoFedelta) c;
			LeggiPrezzo lp = new LeggiPrezzo(cf);
			Executor.perform(lp);
			nuovoPrezzo = lp.getResult();

			Sottoramo1 ramo1 = new Sottoramo1(cf);
			Thread thread_ramo1 = new Thread(ramo1);
			thread_ramo1.start();

			Sottoramo2 ramo2 = new Sottoramo2(nuovoPrezzo);
			Thread thread_ramo2 = new Thread(ramo2);
			thread_ramo2.start();

			try {
				thread_ramo1.join();
				thread_ramo2.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}

			nuoviInterventi = ramo1.getResult();
			boolean accettato = ramo2.estAccettato();

			if (accettato) {
				RegistrazioneFedelta reg = new RegistrazioneFedelta(cf,
						nuovoPrezzo, nuoviInterventi);
				Executor.perform(reg);

				AttivitaIO.MostraDatiContrattoFedelta(nuovoPrezzo, reg
						.getDataScadenza(), nuoviInterventi);
			} else
				AttivitaIO.ContrattoNonRinnovato();

		} else { // contratto standard

			nuovaDurata = AttivitaIO.RichiediNuovoPeriodo();

			CalcoloProposta cp = new CalcoloProposta(c, nuovaDurata);
			Executor.perform(cp);

			nuovoPrezzo = cp.getResult();

			int iterazioni = 0;
			boolean accettato = false;

			while (iterazioni < 3 && !accettato) {
				AttivitaIO.InviaSollecito(nuovoPrezzo);
				accettato = AttivitaIO.RichiediRispostaUtente();
				if (!accettato) {
					nuovoPrezzo -= 10;
					iterazioni += 1;
				}
			}
			
			if (accettato) {
				RegistrazioneStandard reg = new RegistrazioneStandard(c,
						nuovaDurata, nuovoPrezzo);
				Executor.perform(reg);
				AttivitaIO.MostraDatiContrattoStandard(nuovoPrezzo, reg
						.getDataScadenza());
			} else
				AttivitaIO.ContrattoNonRinnovato();
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
