package attivitaprincipale;

import _framework.Executor;
import attivitaatomiche.*;
import contrattofedelta.*;

public class Sottoramo1 implements Runnable {

	private boolean eseguita = false;
	private ContrattoFedelta contratto;
	private int result;

	public Sottoramo1(ContrattoFedelta c) {
		this.contratto = c;
	}

	public void run() {
		if (eseguita == true)
			return;
		eseguita = true;

		CalcoloInterventi ci = new CalcoloInterventi(contratto);
		Executor.perform(ci);
		result = ci.getResult();
	}

	public synchronized int getResult() {
		if (!eseguita)
			throw new RuntimeException(
					"ERRORE: non e' disponibile il risultato su un'attivita' non eseguita");
		return result;
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
