package attivitaprincipale;

import attivitaio.AttivitaIO;

public class Sottoramo2 implements Runnable {
	private boolean eseguita = false;

	private int nuovocosto;
	private boolean accettato;
	
	public Sottoramo2(int c) {
		this.nuovocosto = c;
	}

	public synchronized void run() {
		if (eseguita)
			return;
		eseguita = true;
		AttivitaIO.InviaSollecito(nuovocosto);
		accettato = AttivitaIO.RichiediRispostaUtente();
	}

	public boolean estAccettato() {
		if (!eseguita)
			throw new RuntimeException(
			"ERRORE: non e' disponibile il risultato su un'attivita' non eseguita");
		return accettato;
	}


	public synchronized boolean estEseguita() {
		return eseguita;
	}
	
}
