package contratto;

import possedere.*;
import java.util.*;

public class Contratto {

	public static final int MIN_LINK_POSSEDERE = 1;

	protected String codice;
	protected GregorianCalendar dataScadenza; //una struttura dati standard per date 
	protected int costo;
	protected TipoLinkPossedere link;

	public Contratto(String c) {
		codice = c;
		dataScadenza = null;
		costo = 0;
		link = null;
	}

	public String getCodice() {
		return codice;
	}

	public GregorianCalendar getDataScadenza() {
		return dataScadenza;
	}

	public void setDataScadenza(GregorianCalendar d) {
		dataScadenza = d;
	}

	public int getCosto() {
		return costo;
	}

	public void setCosto(int c) {
		costo = c;
	}

	// gestione dell'associazione "possedere"
	public void inserisciLinkPossedere(TipoLinkPossedere t) {
		if (t != null && t.getContratto() == this)
			ManagerPossedere.inserisci(t);
	}

	public void eliminaLinkPossedere(TipoLinkPossedere t) {
		if (t != null && t.getContratto() == this)
			ManagerPossedere.elimina(t);
	}

	public int quantiPossiede() {
		if (link == null)
			return 0;
		else
			return 1;
	}

	public TipoLinkPossedere getLinkPossedere() {
		if (this.quantiPossiede() < MIN_LINK_POSSEDERE)
			throw new RuntimeException("Molteplicita' minima violata");
		return link;
	}

	public void inserisciPerManagerPossedere(ManagerPossedere a) {
		if (a != null)
			link = a.getLink();
	}

	public void eliminaPerManagerPossedere(ManagerPossedere a) {
		if (a != null)
			link = null;
	}
}