package contrattofedelta;

import contratto.*;
import possederefedelta.*;

public class ContrattoFedelta extends Contratto {
	public ContrattoFedelta(String c) {
		super(c);
	}

	public static final int MIN_LINK_POSSEDERE = 1;

	protected int numeroInterventi;
	protected TipoLinkPossedereFedelta linkF;

	public int getInterventi() {
		return numeroInterventi;
	}

	public void setInterventi(int inter) {
		numeroInterventi = inter;
	}

	// gestione dell'associazione "PossedereFedelta"
	public void inserisciLinkPossedereFedelta(TipoLinkPossedereFedelta t) {
		if (t != null && t.getContratto() == this)
			ManagerPossedereFedelta.inserisci(t);
	}

	public void eliminaLinkPossedereFedelta(TipoLinkPossedereFedelta t) {
		if (t != null && t.getContratto() == this)
			ManagerPossedereFedelta.elimina(t);
	}

	public int quantiPossiedeFedelta() {
		if (linkF == null)
			return 0;
		else
			return 1;
	}

	public TipoLinkPossedereFedelta getLinkPossedereFedelta() {
		if (this.quantiPossiedeFedelta() < MIN_LINK_POSSEDERE)
			throw new RuntimeException("Molteplicità minima violata");
		else if (link == null)
			throw new RuntimeException("Violazione vincolo subset");
		else if (link.getContratto() != this
				|| link.getUtente() != linkF.getUtente())
			throw new RuntimeException("Violazione vincolo subset");
		else
			return linkF;
	}

	public void inserisciPerManagerPossedereFedelta(ManagerPossedereFedelta a) {
		if (a != null)
			linkF = a.getLink();
	}

	public void eliminaPerManagerPossedereFedelta(ManagerPossedereFedelta a) {
		if (a != null)
			linkF = null;
	}
}
