package possedere;

import utente.*;
import contratto.*;

public class TipoLinkPossedere {

	private final Utente lUtente;
	private final Contratto ilContratto;

	public TipoLinkPossedere(Utente u, Contratto c) throws RuntimeException {
		if (u == null || c == null) // CONTROLLO
			// PRECONDIZIONI
			throw new RuntimeException(
					"Gli oggetti devono essere inizializzati");
		this.lUtente = u;
		this.ilContratto = c;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkPossedere b = (TipoLinkPossedere) o;
			return b.lUtente == this.lUtente
					&& b.ilContratto == this.ilContratto;
		} else
			return false;
	}

	public int hashCode() {
		return this.lUtente.hashCode() + this.ilContratto.hashCode();
	}

	public Utente getUtente() {
		return this.lUtente;
	}

	public Contratto getContratto() {
		return this.ilContratto;
	}
}