package possederefedelta;

import utente.*;
import contrattofedelta.*;

public class TipoLinkPossedereFedelta {

	private final Utente lUtente;
	private final ContrattoFedelta ilContratto;

	public TipoLinkPossedereFedelta(Utente u, ContrattoFedelta c)
			throws RuntimeException {
		if (u == null || c == null) // CONTROLLO
			// PRECONDIZIONI
			throw new RuntimeException(
					"Gli oggetti devono essere inizializzati");
		this.lUtente = u;
		this.ilContratto = c;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkPossedereFedelta b = (TipoLinkPossedereFedelta) o;
			return b.lUtente == this.lUtente
					&& b.ilContratto == this.ilContratto;
		} else
			return false;
	}

	public int hashCode() {
		return this.lUtente.hashCode() + this.ilContratto.hashCode();
	}

	public Utente getUtente() {
		return this.lUtente;
	}

	public ContrattoFedelta getContratto() {
		return this.ilContratto;
	}
}