package utente;

import trasmissione.*;
import possedere.*;
import possederefedelta.*;

import java.util.*;

import contratto.Contratto;

public class Utente {
	private String nome, cognome, codiceFiscale;

	private HashSet<Trasmissione> effettuare;
	private HashSet<TipoLinkPossedere> contratti;
	private HashSet<TipoLinkPossedereFedelta> contrattiFedelta;

	public static final int MIN_LINK_POSSEDERE = 1;
	public static final int MAX_LINK_POSSEDERE_FEDELTA = 2;

	public Utente(String n, String c, String cf) {
		nome = n;
		cognome = c;
		codiceFiscale = cf;
		effettuare = new HashSet<Trasmissione>();
		contratti = new HashSet<TipoLinkPossedere>();
		contrattiFedelta = new HashSet<TipoLinkPossedereFedelta>();
	}

	public String getNome() {
		return nome;
	}

	public String getCognome() {
		return cognome;
	}

	public String getCodiceFiscale() {
		return codiceFiscale;
	}

	// gestione dell'associazione "effettuare", a responsabilita'
	// singola da parte di Utente
	public void inserisciLinkEffettuare(Trasmissione t) {
		if (t != null)
			effettuare.add(t);
	}

	public void eliminaLinkEffettuare(Trasmissione t) {
		if (t != null)
			effettuare.remove(t);
	}

	@SuppressWarnings("unchecked")
	public Set<Trasmissione> getLinkEffettuare() {
		return (HashSet<Trasmissione>) effettuare.clone();
	}

	// gestione dell'associazione "possedere"
	public void inserisciLinkPossedere(TipoLinkPossedere t) {
		if (t != null && t.getUtente() == this)
			ManagerPossedere.inserisci(t);
	}

	public void eliminaLinkPossedere(TipoLinkPossedere t) {
		if (t != null && t.getUtente() == this)
			ManagerPossedere.elimina(t);
	}

	public int quantiPossiede() {
		return this.contratti.size();
	}

	@SuppressWarnings("unchecked")
	public Set<TipoLinkPossedere> getLinkPossedere() {
		if (this.quantiPossiede() < MIN_LINK_POSSEDERE)
			throw new RuntimeException("Molteplicità minima violata");
		return (Set<TipoLinkPossedere>) this.contratti.clone();
	}

	public void inserisciPerManagerPossedere(ManagerPossedere a) {
		if (a != null)
			this.contratti.add(a.getLink());
	}

	public void eliminaPerManagerPossedere(ManagerPossedere a) {
		if (a != null)
			this.contratti.remove(a.getLink());
	}

	// gestione dell'associazione "possedere fedelta'"
	public void inserisciLinkPossedereFedelta(TipoLinkPossedereFedelta t) {
		if (t != null && t.getUtente() == this)
			ManagerPossedereFedelta.inserisci(t);
	}

	public void eliminaLinkPossedereFedelta(TipoLinkPossedereFedelta t) {
		if (t != null && t.getUtente() == this)
			ManagerPossedereFedelta.elimina(t);
	}

	public int quantiPossiedeFedelta() {
		return this.contrattiFedelta.size();
	}

	@SuppressWarnings("unchecked")
	public Set<TipoLinkPossedereFedelta> getLinkPossedereFedelta() {
		if (this.quantiPossiedeFedelta() > MAX_LINK_POSSEDERE_FEDELTA)
			throw new RuntimeException("Cardinalita' massima violata");
		else {
			Iterator<TipoLinkPossedereFedelta> it = contrattiFedelta.iterator();
			while (it.hasNext()) {
				Contratto f = it.next().getContratto();
				if (!contratti.contains(new TipoLinkPossedere(this, f)))
					throw new RuntimeException("Violazione vincolo di subset");
			}
			return (Set<TipoLinkPossedereFedelta>) this.contrattiFedelta
					.clone();
		}
	}

	public void inserisciPerManagerPossedereFedelta(ManagerPossedereFedelta a) {
		if (a != null)
			this.contrattiFedelta.add(a.getLink());
	}

	public void eliminaPerManagerPossedereFedelta(ManagerPossedereFedelta a) {
		if (a != null)
			this.contrattiFedelta.remove(a.getLink());
	}

	public String toString() {
		return nome + "/" + cognome + "/" + codiceFiscale;
	}
}