package brano;

import contiene.*;
import java.util.*;

public class Brano {
    private final String nome;
    private final int durata;
    private final String nomefile;
    private HashSet<TipoLinkContiene> insieme_link;
    public Brano(String n, int d, String f) { 
        nome = n; 
        durata = d;
        nomefile = f;
        insieme_link = new HashSet<TipoLinkContiene>();
    }
    public String getNome() { return nome; }
    public int getDurata() { return durata; }
    public String getNomeFile() { return nomefile; }
    public void inserisciLinkContiene(TipoLinkContiene t) { 
      if (t != null && t.getBrano()==this)
         ManagerContiene.inserisci(t);
    }
    public void eliminaLinkContiene(TipoLinkContiene t) {
      if (t != null && t.getBrano()==this)
         ManagerContiene.elimina(t);
    }
    public Set<TipoLinkContiene> getLinkContiene() {
        return (HashSet<TipoLinkContiene>)insieme_link.clone();     
    }
    public void inserisciPerManagerContiene(ManagerContiene a){
        if (a != null) insieme_link.add(a.getLink());
    }      
    public void eliminaPerManagerContiene(ManagerContiene a) {
        if (a != null) insieme_link.remove(a.getLink());
    }
}
