package player;

import eventi.Done;
import eventi.PlaySong;
import eventi.StopSong;
import _gestioneeventi.*;
import brano.*;
import playlist.*;

public class Player implements Listener {

	private Brano branosuonato;

	public Player() {
	}

	// gestione stato

	public static enum Stato {
		PRONTO, ESECUZIONE
	}

	private Stato statocorrente = Stato.PRONTO;
	public PlayList playlist = null;

	public Stato getStato() {
		return statocorrente;
	}

	public Evento fired(Evento e) {
		// filtra eventi non per this o non in broadcasting
		if (e.getDestinatario() != this && e.getDestinatario() != null)
			return null;

		Evento nuovoevento = null;
		switch (statocorrente) {
		case PRONTO:
			if (e.getClass() == PlaySong.class) {
				PlaySong ep = (PlaySong) e;
				playlist = (PlayList) ep.getMittente();
				branosuonato = ep.getBrano();
				System.out.println("Brano in esecuzione: "
						+ branosuonato.getNome());
				nuovoevento = new Evento(this, this); // evento base per attivare nuova transizine
				statocorrente = Stato.ESECUZIONE;
			}
			break;
		case ESECUZIONE:
			if (e.getClass() == Evento.class) {
				System.out.println("Brano terminato : "
						+ branosuonato.getNome());
				branosuonato = null;
				nuovoevento = new Done(this, playlist);
				playlist = null;
				statocorrente = Stato.PRONTO;
			} else if (e.getClass() == StopSong.class) {
				System.out.println("Brano rimosso");
				branosuonato = null;
				playlist = null;
				statocorrente = Stato.PRONTO;
			}
			break;
		default:
			throw new RuntimeException("Stato corrente non riconosciuto.");
		}
		return nuovoevento;
	}

}
