% Unicycle Trajectory Tracking with Approximate Linearization
% G. Oriolo, Sapienza University of Rome

clear all;close all;clc;

global k1 k3 k...
       theta_i theta_f...
       x_i y_i...
       x_f y_f...
       t a z...
       x_0 y_0 theta_0;

% the desired trajectory is a circle centered at the origin
% described as x_d=R*cos(Omega*t), y_d=R*sin(Omega*t)
% choose radius R and frequency Omega
R=2;
Omega=4;
% corresponding to 
x_d0=R;
y_d0=0;

% since the Cartesian trajectory is a circle, the reconstruction
% formulas directly give 
% theta_d=theta_d0+Omega*t with 
theta_d0=pi/2; 
% and reference velocities given by
v_d=R*Omega; % nominal driving vel
om_d=Omega;  % nominal steering vel

% actual start configuration is a perturbation of the nominal start
eps=3; % eps=3 works with Omega=3 or less; for Omega=4 you need eps=1
x_0=x_d0+eps;y_0=y_d0-eps;theta_0=theta_d0-eps;

% choose controller parameters
a = 7;
z = 0.7;
% then we let
k1 = 2*z*a;
k3 = 2*z*a;
k2 = (a^2-(om_d)^2)/v_d;

% choose simulation time
T=2*ceil(2+pi/Omega);

% Running simulink
sim('model.slx');

% Plot Window parameters
minX = min(x)-2;maxX = max(x)+2;minY = min(y)-2;maxY = max(y)+2;

figure(1)
for i = 1:length(tout)
    plot(x_d(1:i),y_d(1:i),'--g');
    axis([minX, maxX, minY, maxY]);
    axis equal
    grid;
    hold on;
    plot(x(1:i), y(1:i),'--r');
    [X0,Y0] = getTriangle(x_0,y_0,theta_0,0.3);
    [XD0,YD0] = getTriangle(x_d0,y_d0,theta_d0,0.3);
    plot(X0,Y0,'r');
    plot(XD0,YD0,'g');
    hold off;
end

figure(2)
plot(tout,e1.^2+e2.^2+e3.^2);title("tracking error")
