function y = rotatePlanar(x, p, theta)
% Rotate element x of an angle theta around the point p (it's a planar
% rotation)

R = [cos(theta), -sin(theta); sin(theta), cos(theta)];

N = length(x);

y = (R*(x-repmat(p,N,1))')'+repmat(p,N,1);

end